#include <bits/stdc++.h>
using namespace std;

struct Node {
    array<int, 10> nxt{};
    string endNum;
    Node() { nxt.fill(-1); }
};

vector<Node> trie(1);

int addNode() {
    trie.emplace_back();
    return (int)trie.size() - 1;
}

void insertNum(const string &s) {
    int v = 0;
    for (char c : s) {
        int d = c - '0';
        if (trie[v].nxt[d] == -1)
            trie[v].nxt[d] = addNode();
        v = trie[v].nxt[d];
    }
    trie[v].endNum = s;
}

vector<vector<string>> dfs(int v) {
    vector<vector<string>> res;
    for (int d = 0; d < 10; ++d) {
        int nxt = trie[v].nxt[d];
        if (nxt != -1) {
            auto child = dfs(nxt);
            for (auto &vec : child) res.push_back(move(vec));
        }
    }

    if (!trie[v].endNum.empty()) {
        if (res.empty()) {
            res.push_back({trie[v].endNum});
        } else {
            for (auto &vec : res)
                vec.push_back(trie[v].endNum);
        }
    }

    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<string> nums(n);
    for (auto &x : nums) cin >> x;

    for (auto &s : nums)
        insertNum(s);

    auto subsets = dfs(0);

    cout << subsets.size() << "\n";
    for (auto &sub : subsets) {
        cout << sub.size() << "\n";
        for (auto &x : sub) cout << x << " ";
        cout << "\n";
    }
}
